/*

  Macro_Scripts File
Purposes:  
    
	define actions for the viewport shading manager introduced in 3ds max 10

Revision History
	March 2007: Neil Hazzard
	created for 3ds MAX 10
*/

-- Macro Scripts for IViewportShadingMgr
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************
MacroScript Viewport_Shading_Display_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.DisplayOnlySelectedLights()
)

MacroScript Viewport_Shading_Toggle_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_TOOLTIP~ 
(
	on ischecked do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			return (viewportViewSetting.AutoDisplaySelectedLightEnabled == true)
		)
		else
		(
			return IViewportShadingMgr.AutoDisplaySelLights
		)
	)
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)
	On Execute Do
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			Try (viewportViewSetting.AutoDisplaySelectedLightEnabled = (not viewportViewSetting.AutoDisplaySelectedLightEnabled))
			catch()	
		)
		else
		(
			Try (IViewportShadingMgr.AutoDisplaySelLights  = (not IViewportShadingMgr.AutoDisplaySelLights ))	
			catch()
		)
	)
)

MacroScript Viewport_Shading_Lock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights true
	
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Unlock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights false
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Select_Illuminating_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_TOOLTIP~  
(
	On Execute Do IViewportShadingMgr.SelectIlluminatingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Select_Shadow_Casting_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.SelectShadowCastingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Enable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly true
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Disable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly false
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_GPU_Diagnostics
            ButtonText:~VIEWPORT_GPU_DIAGNOSTICS_BUTTONTEXT~
            category:~VIEWPORT_GPU_DIAGNOSTICS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_GPU_DIAGNOSTICS_TOOLTIP~ 
(
	On Execute Do
	(
		if (classof(renderers.current) == mental_ray_iray_renderer) do
		(
			setListenerSelText renderers.current.hardwareReport
			setListenerSelText "\n\n"
		)
		-- Alwasy print the OGS diagnostics
		setListenerSelText OGSDiagnostics.hardwareReport

		if NitrousGraphicsManager.isEnabled() != true do
			IViewportShadingMgr.ReviewGPUDiagnostics()
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAEgWEOpptRpPn71FtXFMeN8ZGVzleISFBO
-- E6yf8DyySA4QRe5HeG5XDx6R8ePsLgWeH3CGAi2GWVQnaFKW2dn1YzoYt85yB3op
-- Idga/g+KgsrhrpUKEn+OfmiMMA5wMnmupH9WFt7sQTEM1zPBvxMDxB5iCPiL0esz
-- bvhN3hPLSeRF2Q2QbVBdLJ/5kyb6tlqV4dIqhcVrlNUNZXmAkgafkRhaH2IX/plq
-- aqFHt4cBXUCB+iPjGqN8ziL/yT8syRWXfP+kuhdmRj/4FPZdxbg7QizaD581ZX2s
-- 3Ec3zfAfX+8AwjPETuDg6yXqCvz6MyzIt/o9uBsY7+vtFwdTJH2A
-- -----END-SIGNATURE-----